# 📝 Aide-mémoire Breizhcalendar

## Installation rapide
```bash
sudo ./install.sh
sudo certbot --apache -d breizhcalendar.ezeo.bzh
sudo systemctl restart apache2
```

## Commandes utiles

### Apache
```bash
# Tester la config
sudo apache2ctl configtest

# Redémarrer
sudo systemctl restart apache2

# Recharger (sans interruption)
sudo systemctl reload apache2

# Status
sudo systemctl status apache2
```

### Logs
```bash
# Erreurs en temps réel
sudo tail -f /var/log/apache2/breizhcalendar_ssl_error.log

# Accès en temps réel
sudo tail -f /var/log/apache2/breizhcalendar_ssl_access.log

# Dernières 50 lignes
sudo tail -n 50 /var/log/apache2/breizhcalendar_ssl_error.log
```

### Permissions
```bash
# Corriger toutes les permissions
sudo chown -R www-data:www-data /var/www/breizhcalendar
sudo chmod 755 /var/www/breizhcalendar
sudo chmod 644 /var/www/breizhcalendar/*.html
sudo chmod 644 /var/www/breizhcalendar/*.php
sudo chmod 664 /var/www/breizhcalendar/events.json
```

### Backup
```bash
# Backup manuel
sudo cp /var/www/breizhcalendar/events.json /var/backups/events-$(date +%Y%m%d-%H%M).json

# Restaurer
sudo cp /var/backups/events-20241120-1400.json /var/www/breizhcalendar/events.json
sudo chown www-data:www-data /var/www/breizhcalendar/events.json
```

### SSL
```bash
# Renouveler le certificat
sudo certbot renew

# Test de renouvellement
sudo certbot renew --dry-run

# Lister les certificats
sudo certbot certificates
```

### Tests API
```bash
# Lister les événements
curl https://breizhcalendar.ezeo.bzh/api.php?action=events

# Statistiques
curl https://breizhcalendar.ezeo.bzh/api.php?action=stats

# Créer un événement
curl -X POST https://breizhcalendar.ezeo.bzh/api.php?action=create \
  -H "Content-Type: application/json" \
  -d '{"title":"Test","start":"2024-12-01","scope":"local","backgroundColor":"#3b82f6"}'
```

### Vhost
```bash
# Éditer le vhost
sudo nano /etc/apache2/sites-available/breizhcalendar.conf

# Désactiver
sudo a2dissite breizhcalendar.conf

# Activer
sudo a2ensite breizhcalendar.conf

# Lister les sites actifs
ls -la /etc/apache2/sites-enabled/
```

### Modules Apache
```bash
# Lister les modules activés
apache2ctl -M

# Activer un module
sudo a2enmod rewrite

# Désactiver un module
sudo a2dismod status
```

## Chemins importants

| Type | Chemin |
|------|--------|
| Application | `/var/www/breizhcalendar/` |
| Vhost | `/etc/apache2/sites-available/breizhcalendar.conf` |
| Données | `/var/www/breizhcalendar/events.json` |
| Logs erreurs | `/var/log/apache2/breizhcalendar_ssl_error.log` |
| Logs accès | `/var/log/apache2/breizhcalendar_ssl_access.log` |
| Certificat SSL | `/etc/letsencrypt/live/breizhcalendar.ezeo.bzh/` |

## Diagnostic rapide

### Problème : Site inaccessible
```bash
# 1. Apache tourne ?
sudo systemctl status apache2

# 2. Config valide ?
sudo apache2ctl configtest

# 3. Site activé ?
ls -la /etc/apache2/sites-enabled/ | grep breizhcalendar

# 4. Port ouvert ?
sudo netstat -tlnp | grep :443
```

### Problème : API ne répond pas
```bash
# 1. PHP fonctionne ?
php -v
sudo systemctl status php8.2-fpm

# 2. Fichier API accessible ?
ls -la /var/www/breizhcalendar/api.php

# 3. Permissions events.json ?
ls -la /var/www/breizhcalendar/events.json

# 4. Test direct
curl -I https://breizhcalendar.ezeo.bzh/api.php?action=stats
```

### Problème : 403 Forbidden
```bash
# Vérifier propriétaire et permissions
ls -la /var/www/breizhcalendar/

# Corriger
sudo chown -R www-data:www-data /var/www/breizhcalendar
sudo chmod 755 /var/www/breizhcalendar
```

### Problème : SSL ne fonctionne pas
```bash
# Vérifier le certificat
sudo certbot certificates

# Renouveler si expiré
sudo certbot renew

# Vérifier la config SSL dans le vhost
sudo nano /etc/apache2/sites-available/breizhcalendar.conf
```

## Maintenance courante

### Nettoyage des logs
```bash
# Vider les logs (garder les 1000 dernières lignes)
sudo tail -n 1000 /var/log/apache2/breizhcalendar_ssl_access.log > /tmp/access.log
sudo mv /tmp/access.log /var/log/apache2/breizhcalendar_ssl_access.log
```

### Mise à jour de l'application
```bash
# 1. Backup
sudo cp /var/www/breizhcalendar/events.json /tmp/backup-events.json

# 2. Copier nouveaux fichiers
sudo cp nouveaux-fichiers/* /var/www/breizhcalendar/

# 3. Restaurer données
sudo cp /tmp/backup-events.json /var/www/breizhcalendar/events.json

# 4. Permissions
sudo chown -R www-data:www-data /var/www/breizhcalendar
```

## Monitoring

### Espace disque
```bash
df -h | grep /var
```

### Utilisation CPU/RAM Apache
```bash
ps aux | grep apache2
```

### Nombre de connexions actives
```bash
sudo netstat -an | grep :443 | grep ESTABLISHED | wc -l
```

### Dernières erreurs
```bash
sudo tail -20 /var/log/apache2/breizhcalendar_ssl_error.log
```

## URLs importantes

- **Application** : https://breizhcalendar.ezeo.bzh/index-api.html
- **API events** : https://breizhcalendar.ezeo.bzh/api.php?action=events
- **API stats** : https://breizhcalendar.ezeo.bzh/api.php?action=stats
