# 🚀 Guide de déploiement rapide - Breizhcalendar

## Installation en 3 commandes

### 1️⃣ Préparation
```bash
# Décompresser l'archive sur ton serveur
cd /tmp
unzip calendrier-prototype.zip
cd calendrier-prototype
```

### 2️⃣ Installation automatique
```bash
# Lancer le script d'installation
sudo ./install.sh
```

### 3️⃣ Configuration SSL
```bash
# Obtenir un certificat Let's Encrypt
sudo certbot --apache -d breizhcalendar.ezeo.bzh

# Redémarrer Apache
sudo systemctl restart apache2
```

## 📋 Checklist pré-installation

- [ ] Serveur Debian/Ubuntu avec Apache installé
- [ ] PHP 8.x installé et configuré
- [ ] Module Apache `php-fpm` activé
- [ ] DNS configuré : `breizhcalendar.ezeo.bzh` → IP du serveur
- [ ] Port 80 et 443 ouverts dans le firewall
- [ ] Certbot installé pour Let's Encrypt

## 🛠️ Installation manuelle (si besoin)

Si tu préfères installer manuellement :

```bash
# 1. Créer le répertoire
sudo mkdir -p /var/www/breizhcalendar

# 2. Copier les fichiers
sudo cp *.html *.php *.json .htaccess /var/www/breizhcalendar/

# 3. Permissions
sudo chown -R www-data:www-data /var/www/breizhcalendar
sudo chmod 664 /var/www/breizhcalendar/events.json

# 4. Copier le vhost
sudo cp breizhcalendar.conf /etc/apache2/sites-available/

# 5. Activer les modules
sudo a2enmod ssl headers rewrite proxy_fcgi

# 6. Activer le site
sudo a2ensite breizhcalendar.conf

# 7. Tester la config
sudo apache2ctl configtest

# 8. SSL
sudo certbot --apache -d breizhcalendar.ezeo.bzh

# 9. Redémarrer
sudo systemctl restart apache2
```

## 🔧 Configuration post-installation

### Modifier le domaine
Si tu veux utiliser un autre domaine :

```bash
# Éditer le vhost
sudo nano /etc/apache2/sites-available/breizhcalendar.conf

# Changer les lignes ServerName et ServerAlias
# Puis relancer certbot avec le nouveau domaine
```

### Ajuster PHP
Si tu as une version différente de PHP :

```bash
# Éditer le vhost
sudo nano /etc/apache2/sites-available/breizhcalendar.conf

# Ligne à modifier (exemple pour PHP 8.3) :
SetHandler "proxy:unix:/run/php/php8.3-fpm.sock|fcgi://localhost"
```

### Permissions events.json
Le fichier `events.json` doit être modifiable par Apache :

```bash
sudo chown www-data:www-data /var/www/breizhcalendar/events.json
sudo chmod 664 /var/www/breizhcalendar/events.json
```

## 🧪 Tests

### Test 1 : Accès HTTP → HTTPS
```bash
curl -I http://breizhcalendar.ezeo.bzh
# Doit retourner un code 301 (redirection)
```

### Test 2 : Accès HTTPS
```bash
curl -I https://breizhcalendar.ezeo.bzh
# Doit retourner un code 200
```

### Test 3 : API
```bash
curl https://breizhcalendar.ezeo.bzh/api.php?action=events
# Doit retourner du JSON avec les événements
```

### Test 4 : Écriture
```bash
# Créer un événement de test
curl -X POST https://breizhcalendar.ezeo.bzh/api.php?action=create \
  -H "Content-Type: application/json" \
  -d '{
    "title": "Test",
    "start": "2024-12-01",
    "scope": "local",
    "backgroundColor": "#3b82f6"
  }'
```

## 📊 Monitoring

### Logs Apache
```bash
# Logs d'erreur
sudo tail -f /var/log/apache2/breizhcalendar_ssl_error.log

# Logs d'accès
sudo tail -f /var/log/apache2/breizhcalendar_ssl_access.log
```

### Statistiques
```bash
# Voir les stats des événements
curl https://breizhcalendar.ezeo.bzh/api.php?action=stats
```

## 🔐 Sécurité

### Sauvegardes automatiques
Créer un cron pour sauvegarder `events.json` :

```bash
# Éditer le crontab
sudo crontab -e

# Ajouter cette ligne (backup quotidien à 2h du matin)
0 2 * * * cp /var/www/breizhcalendar/events.json /var/backups/breizhcalendar/events-$(date +\%Y\%m\%d).json
```

### Firewall (UFW)
```bash
sudo ufw allow 80/tcp
sudo ufw allow 443/tcp
sudo ufw enable
```

### Fail2ban
Créer un filtre pour l'API si besoin de protection contre le bruteforce.

## 🐛 Dépannage

### Problème : Page blanche
```bash
# Vérifier les logs PHP
sudo tail -f /var/log/apache2/breizhcalendar_ssl_error.log

# Vérifier que PHP fonctionne
php -v
sudo systemctl status php8.2-fpm
```

### Problème : 403 Forbidden
```bash
# Vérifier les permissions
ls -la /var/www/breizhcalendar

# Corriger si nécessaire
sudo chown -R www-data:www-data /var/www/breizhcalendar
sudo chmod 755 /var/www/breizhcalendar
```

### Problème : L'API ne fonctionne pas
```bash
# Vérifier que events.json est accessible en écriture
ls -la /var/www/breizhcalendar/events.json

# Corriger
sudo chown www-data:www-data /var/www/breizhcalendar/events.json
sudo chmod 664 /var/www/breizhcalendar/events.json
```

### Problème : Certificat SSL
```bash
# Renouveler le certificat
sudo certbot renew --dry-run

# Si problème, supprimer et recréer
sudo certbot delete
sudo certbot --apache -d breizhcalendar.ezeo.bzh
```

## 🔄 Mise à jour

Pour mettre à jour l'application :

```bash
# 1. Sauvegarder les données
sudo cp /var/www/breizhcalendar/events.json /tmp/events-backup.json

# 2. Copier les nouveaux fichiers
sudo cp nouveaux-fichiers/* /var/www/breizhcalendar/

# 3. Restaurer les données
sudo cp /tmp/events-backup.json /var/www/breizhcalendar/events.json

# 4. Vérifier les permissions
sudo chown -R www-data:www-data /var/www/breizhcalendar

# 5. Pas besoin de redémarrer Apache (sauf si vhost modifié)
```

## 📱 URL d'accès finale

- **Version API (recommandée)** : https://breizhcalendar.ezeo.bzh/index-api.html
- **Version standalone** : https://breizhcalendar.ezeo.bzh/index.html
- **API REST** : https://breizhcalendar.ezeo.bzh/api.php

## 💡 Prochaines étapes

Une fois installé, tu peux :
1. Personnaliser les couleurs dans `events.json`
2. Ajouter des événements via l'API
3. Créer une interface d'administration
4. Intégrer avec ton infrastructure Ézéo existante

---

**Support** : Si tu rencontres des problèmes, check les logs Apache !
