# Calendrier des Événements - Prototype

Prototype d'application de calendrier événementiel basé sur FullCalendar (version gratuite MIT).

## 📁 Structure des fichiers

```
.
├── index.html          # Version standalone (sans backend)
├── index-api.html      # Version avec API PHP
├── api.php            # API REST PHP
├── events.json        # Données des événements (base de données simple)
└── README.md          # Ce fichier
```

## 🚀 Installation

### Option 1 : Version standalone (démo rapide)

Ouvrir simplement `index.html` dans un navigateur. Tout fonctionne sans serveur.

### Option 2 : Version avec API PHP (recommandée)

1. **Copier les fichiers sur un serveur web avec PHP :**
   ```bash
   # Exemple avec Apache sur Debian
   sudo cp * /var/www/html/calendrier/
   ```

2. **Vérifier les permissions :**
   ```bash
   # Le fichier events.json doit être accessible en écriture par PHP
   sudo chown www-data:www-data events.json
   sudo chmod 644 events.json
   ```

3. **Accéder à l'application :**
   ```
   http://votre-serveur/calendrier/index-api.html
   ```

## ⚙️ Fonctionnalités

### ✅ Implémentées

- **Affichage calendrier** : Vue mois, semaine, liste
- **Filtrage par portée** : Mondial, International, Européen, National, Régional, Local
- **Filtrage par organisation** : BREIZHCOOP, FRAIS, ESA, ESU
- **Événements multi-jours** : Support natif des événements étalés
- **Statistiques en temps réel** : Compteurs par catégorie
- **Modal détails** : Clic sur un événement pour voir les détails
- **Design moderne** : Tailwind CSS + interface responsive
- **Numéros de semaine** : Affichés dans la vue mois

### 🎨 Personnalisation

#### Couleurs des événements

Modifier dans `events.json` :
```json
{
  "backgroundColor": "#10b981",
  "borderColor": "#059669"
}
```

#### Catégories de portée

Modifier dans `api.php` ou directement le filtrage JS.

## 🔌 API REST (api.php)

### Endpoints disponibles

#### GET /api.php?action=events
Récupère tous les événements (avec filtres optionnels)

**Paramètres :**
- `scope` : mondial|international|europeen|national|regional|local
- `category` : nom de la catégorie
- `organization` : nom de l'organisation

**Exemple :**
```bash
curl "http://localhost/calendrier/api.php?action=events&scope=national"
```

**Réponse :**
```json
{
  "success": true,
  "count": 2,
  "events": [...]
}
```

#### GET /api.php?action=stats
Récupère les statistiques

**Réponse :**
```json
{
  "success": true,
  "stats": {
    "total": 18,
    "by_scope": {
      "mondial": 1,
      "national": 2,
      ...
    },
    "by_category": {...}
  }
}
```

#### POST /api.php?action=create
Crée un nouvel événement

**Body JSON :**
```json
{
  "title": "Mon événement",
  "start": "2024-12-01",
  "end": "2024-12-03",
  "scope": "regional",
  "backgroundColor": "#3b82f6",
  "description": "Description de l'événement"
}
```

#### PUT /api.php?action=update&id=1
Met à jour un événement existant

#### DELETE /api.php?action=delete&id=1
Supprime un événement

## 🛠️ Technologies utilisées

- **FullCalendar 6.1** (licence MIT - gratuite)
- **Tailwind CSS 3** (via CDN)
- **PHP 8.x** (backend API)
- **JSON** (stockage simple)
- **Vanilla JavaScript** (pas de framework lourd)

## 📊 Format des données (events.json)

```json
{
  "id": 1,
  "title": "Nom de l'événement",
  "start": "2020-09-12",
  "end": "2020-09-27",           // Optionnel
  "backgroundColor": "#10b981",
  "borderColor": "#059669",
  "scope": "national",            // mondial|international|europeen|national|regional|local
  "category": "fete-possibles",
  "organization": "BREIZHCOOP",  // Optionnel
  "description": "Description"    // Optionnel
}
```

## 🎯 Prochaines étapes possibles

### Court terme
- [ ] Formulaire d'ajout d'événements (interface UI)
- [ ] Édition d'événements en drag & drop
- [ ] Export iCal / Google Calendar
- [ ] Impression optimisée
- [ ] Recherche textuelle

### Moyen terme
- [ ] Authentification utilisateurs
- [ ] Permissions (admin / lecteur)
- [ ] Base de données PostgreSQL/MySQL
- [ ] Upload d'images pour les événements
- [ ] Notifications par email

### Long terme
- [ ] Application mobile (PWA)
- [ ] Synchronisation avec calendriers externes
- [ ] Vue carte géographique
- [ ] API publique avec rate limiting
- [ ] Interface d'administration complète

## 🐛 Débogage

### Problème : Les événements ne s'affichent pas (version API)

1. Vérifier que PHP fonctionne :
   ```bash
   php -v
   ```

2. Tester l'API directement :
   ```bash
   curl http://localhost/calendrier/api.php?action=events
   ```

3. Vérifier les logs Apache/Nginx :
   ```bash
   sudo tail -f /var/log/apache2/error.log
   ```

4. Vérifier la console JavaScript du navigateur (F12)

### Problème : Erreur "Permission denied" sur events.json

```bash
sudo chown www-data:www-data events.json
sudo chmod 644 events.json
```

## 📝 Licence

- FullCalendar : MIT License
- Code custom : À définir selon vos besoins

## 👨‍💻 Développement

Ce prototype a été créé pour Ézéo (SCOP Bretagne) dans le cadre d'un projet de calendrier événementiel pour l'ESS.

**Caractéristiques :**
- Code simple et maintenable
- Déploiement facile sur serveurs Debian
- Pas de dépendances npm/build
- Backend PHP vanilla (pas de framework)
- Architecture évolutive

## 🔗 Ressources

- [Documentation FullCalendar](https://fullcalendar.io/docs)
- [Tailwind CSS](https://tailwindcss.com)
- [PHP Documentation](https://www.php.net/manual/fr/)

---

**Contact :** Pour toute question sur ce prototype, n'hésitez pas !
