# 📦 Package Breizhcalendar - Contenu complet

## 🎯 Vues disponibles (3 versions)

### 1. 📅 Vue Calendrier classique
- **index.html** - Version standalone (sans backend)
- **index-api.html** - Version avec API PHP ⭐ Pour mobile/tablette

### 2. 📊 Vue Gantt simple  
- **gantt-frappe.html** - Vue timeline horizontale simple et épurée

### 3. 🗓️ Vue Timeline avec groupes
- **gantt-timeline.html** - Vue dense avec groupes ⭐ **RECOMMANDÉ pour desktop**

---

## 🔧 Backend et données

- **api.php** - API REST complète (GET, POST, PUT, DELETE)
- **events.json** - Base de données des événements (18 événements d'exemple)

---

## 📚 Documentation

- **README.md** - Documentation générale du projet
- **DEPLOIEMENT.md** - Guide d'installation pas à pas
- **COMMANDES.md** - Aide-mémoire des commandes utiles
- **COMPARAISON-VUES.md** - Comparatif détaillé des 3 vues

---

## ⚙️ Configuration Apache

- **breizhcalendar-http.conf** - Vhost HTTP simple ⭐ **À utiliser**
- **breizhcalendar.conf** - Vhost HTTPS complet (pour après certbot)
- **htaccess** - Fichier .htaccess (optimisations et sécurité)

---

## 🚀 Installation

- **install.sh** - Script d'installation automatique (à lancer en sudo)

---

## 📁 Structure de déploiement

```
/var/www/breizhcalendar/
├── index.html                    # Vue calendrier standalone
├── index-api.html                # Vue calendrier avec API
├── gantt-frappe.html            # Vue Gantt simple
├── gantt-timeline.html          # Vue Timeline groupée ⭐
├── api.php                       # API REST
├── events.json                   # Données
├── .htaccess                     # Config Apache
└── README.md                     # Doc
```

---

## 🎨 Caractéristiques communes aux 3 vues

✅ **Design moderne** avec Tailwind CSS
✅ **Filtrage par portée** (Mondial → Local)
✅ **Couleurs personnalisées** par catégorie
✅ **Sidebar avec statistiques**
✅ **Responsive** (index-api.html optimal mobile)
✅ **Données en temps réel** via API

---

## 🔗 URLs après installation

```
http://breizhcalendar.ezeo.bzh/
├── gantt-timeline.html      ← Page d'accueil recommandée (desktop)
├── index-api.html          ← Alternative calendrier classique
├── gantt-frappe.html       ← Gantt simple
└── api.php?action=events   ← API REST
```

---

## 📊 Détails des vues

### Vue Timeline (gantt-timeline.html) - RECOMMANDÉE ⭐

**Bibliothèque:** vis-timeline (MIT)

**Points forts:**
- ✅ Vue horizontale dense comme ta maquette
- ✅ Groupes par portée géographique
- ✅ Zoom fluide (semaine → trimestre)
- ✅ Gestion des chevauchements
- ✅ Numéros de semaine
- ✅ Toggle groupes on/off
- ✅ Statistiques dynamiques

**Idéal pour:**
- Visualiser de nombreux événements simultanés
- Planning d'organisation type ESS/coopérative
- Vue d'ensemble chronologique

---

### Vue Calendrier (index-api.html)

**Bibliothèque:** FullCalendar (MIT)

**Points forts:**
- ✅ Interface calendrier traditionnelle
- ✅ Vues mois/semaine/liste
- ✅ Excellent sur mobile
- ✅ Drag & drop natif
- ✅ Modal détails événement

**Idéal pour:**
- Usage mobile/tablette
- Calendrier personnel
- Interface utilisateur classique

---

### Vue Gantt (gantt-frappe.html)

**Bibliothèque:** Frappe Gantt (MIT)

**Points forts:**
- ✅ Simple et épuré
- ✅ Vue projet/tâches
- ✅ Léger et rapide
- ✅ Drag & drop

**Idéal pour:**
- Planning de projet
- Timeline simple
- Vue chronologique épurée

---

## 🎯 Recommandations d'usage

### Pour Ézéo / BREIZHCOOP

**Desktop (recommandé):**
```apache
DirectoryIndex gantt-timeline.html index-api.html
```
→ Vue dense avec groupes pour visualiser tous les événements ESS

**Mobile/Tablette:**
Détecter l'appareil et rediriger vers index-api.html

**Alternative:**
Proposer un switch dans l'interface pour choisir la vue

---

## 🔐 Sécurité

✅ HTTPS avec Let's Encrypt (après déploiement)
✅ Headers de sécurité (X-Frame-Options, etc.)
✅ Protection fichiers sensibles
✅ Permissions correctes sur events.json
✅ Validation des entrées API

---

## 📈 Évolutions possibles

### Court terme
- [ ] Formulaire d'ajout événements (UI)
- [ ] Édition inline (drag & drop)
- [ ] Export iCal
- [ ] Recherche textuelle

### Moyen terme
- [ ] Authentification
- [ ] Permissions (admin/lecteur)
- [ ] Base de données PostgreSQL
- [ ] Upload images événements

### Long terme
- [ ] Application mobile (PWA)
- [ ] Sync calendriers externes
- [ ] Vue carte géographique
- [ ] Notifications email/push

---

## 🛠️ Technologies utilisées

| Composant | Technologie | Licence |
|-----------|-------------|---------|
| Vue Timeline | vis-timeline 7.7 | MIT |
| Vue Gantt | Frappe Gantt 0.6 | MIT |
| Vue Calendrier | FullCalendar 6.1 | MIT |
| CSS | Tailwind CSS 3 | MIT |
| Backend | PHP 8.x | PHP License |
| Frontend | Vanilla JavaScript | - |

**100% Open Source et gratuit !**

---

## 📞 Support

### Logs
```bash
sudo tail -f /var/log/apache2/breizhcalendar_error.log
```

### Tests
```bash
# Test API
curl http://breizhcalendar.ezeo.bzh/api.php?action=events

# Test permissions
ls -la /var/www/breizhcalendar/events.json
```

### Docs
- README.md : Documentation générale
- DEPLOIEMENT.md : Installation complète
- COMMANDES.md : Commandes utiles
- COMPARAISON-VUES.md : Choisir la bonne vue

---

## 🎁 Contenu du ZIP

```
breizhcalendar-complet.zip (32 Ko)
├── 📄 HTML (4 fichiers)
│   ├── index.html
│   ├── index-api.html
│   ├── gantt-frappe.html
│   └── gantt-timeline.html
├── 🔧 Backend (2 fichiers)
│   ├── api.php
│   └── events.json
├── 📚 Documentation (4 fichiers)
│   ├── README.md
│   ├── DEPLOIEMENT.md
│   ├── COMMANDES.md
│   └── COMPARAISON-VUES.md
└── ⚙️ Configuration (3 fichiers)
    ├── breizhcalendar-http.conf ⭐
    ├── breizhcalendar.conf
    ├── install.sh
    └── htaccess
```

---

## 🚀 Démarrage rapide

### Installation en 3 commandes

```bash
# 1. Décompresser
unzip breizhcalendar-complet.zip

# 2. Installer
sudo ./install.sh

# 3. Configurer Apache
sudo cp breizhcalendar-http.conf /etc/apache2/sites-available/breizhcalendar.conf
sudo a2ensite breizhcalendar.conf
sudo systemctl restart apache2
```

### SSL Let's Encrypt (après)

```bash
sudo certbot --apache -d breizhcalendar.ezeo.bzh
```

---

## ✅ Checklist déploiement

- [ ] DNS configuré (breizhcalendar.ezeo.bzh)
- [ ] Apache installé et configuré
- [ ] PHP 8.x installé
- [ ] Fichiers décompressés
- [ ] Script install.sh exécuté
- [ ] Vhost activé
- [ ] Apache redémarré
- [ ] Test accès HTTP
- [ ] Certbot exécuté
- [ ] Test accès HTTPS
- [ ] Permissions events.json vérifiées
- [ ] API testée

---

**🎉 Prêt à l'emploi !**

Commence par tester les 3 vues et choisis celle qui te convient le mieux.
Ma recommandation : **gantt-timeline.html** pour ton cas d'usage.
