# ⚡ DÉMARRAGE RAPIDE

## Test immédiat (sans serveur)

**Ouvre simplement ces fichiers dans ton navigateur :**

1. **gantt-timeline.html** ⭐ - Vue timeline avec groupes (recommandée)
2. **gantt-frappe.html** - Vue Gantt simple
3. **index.html** - Vue calendrier classique

→ Double-clic sur le fichier HTML, ça fonctionne directement !

---

## Installation sur serveur (3 minutes)

```bash
# 1. Décompresser
unzip breizhcalendar-complet.zip
cd breizhcalendar-*

# 2. Copier les fichiers
sudo mkdir -p /var/www/breizhcalendar
sudo cp *.html *.php *.json htaccess /var/www/breizhcalendar/
sudo mv /var/www/breizhcalendar/htaccess /var/www/breizhcalendar/.htaccess

# 3. Permissions
sudo chown -R www-data:www-data /var/www/breizhcalendar
sudo chmod 664 /var/www/breizhcalendar/events.json

# 4. Vhost Apache
sudo cp breizhcalendar-http.conf /etc/apache2/sites-available/breizhcalendar.conf
sudo a2ensite breizhcalendar.conf
sudo a2enmod rewrite proxy_fcgi

# 5. Redémarrer Apache
sudo systemctl restart apache2
```

**C'est prêt !** → http://breizhcalendar.ezeo.bzh

---

## SSL Let's Encrypt (après)

```bash
sudo certbot --apache -d breizhcalendar.ezeo.bzh
```

---

## Quelle vue choisir ?

### 🗓️ gantt-timeline.html ⭐ RECOMMANDÉ
**Pour :** Vue dense avec beaucoup d'événements
**Comme :** Ta maquette originale
**Desktop uniquement**

### 📊 gantt-frappe.html
**Pour :** Planning de projet simple
**Joli et épuré**

### 📅 index-api.html
**Pour :** Calendrier classique
**Mobile/tablette**

---

## Test l'API

```bash
# Lister les événements
curl http://breizhcalendar.ezeo.bzh/api.php?action=events

# Statistiques
curl http://breizhcalendar.ezeo.bzh/api.php?action=stats
```

---

## Problèmes ?

**1. Page blanche ?**
```bash
sudo tail -f /var/log/apache2/breizhcalendar_error.log
```

**2. 403 Forbidden ?**
```bash
sudo chown -R www-data:www-data /var/www/breizhcalendar
```

**3. API ne fonctionne pas ?**
```bash
sudo chmod 664 /var/www/breizhcalendar/events.json
```

---

## 📚 Documentation complète

- **INDEX.md** - Vue d'ensemble du package
- **DEPLOIEMENT.md** - Installation détaillée
- **COMPARAISON-VUES.md** - Comparatif des 3 vues
- **COMMANDES.md** - Commandes utiles

---

**Besoin d'aide ?** Check les logs Apache !
