#!/bin/bash
#
# Script d'installation du calendrier Breizhcalendar
# Usage: sudo ./install.sh
#

set -e

echo "================================================"
echo "Installation de Breizhcalendar"
echo "================================================"
echo ""

# Vérifier que le script est exécuté en root
if [ "$EUID" -ne 0 ]; then 
    echo "❌ Ce script doit être exécuté en root (sudo)"
    exit 1
fi

# Variables
DOMAIN="breizhcalendar.ezeo.bzh"
WEB_DIR="/var/www/breizhcalendar"
VHOST_FILE="/etc/apache2/sites-available/breizhcalendar.conf"

echo "📁 Création du répertoire $WEB_DIR..."
mkdir -p "$WEB_DIR"

echo "📦 Copie des fichiers de l'application..."
# Copier tous les fichiers HTML, PHP, JSON
cp index.html "$WEB_DIR/"
cp index-api.html "$WEB_DIR/"
cp api.php "$WEB_DIR/"
cp events.json "$WEB_DIR/"
cp README.md "$WEB_DIR/"

echo "🔐 Configuration des permissions..."
chown -R www-data:www-data "$WEB_DIR"
chmod 755 "$WEB_DIR"
chmod 644 "$WEB_DIR"/*.html
chmod 644 "$WEB_DIR"/*.php
chmod 664 "$WEB_DIR"/events.json  # Écriture nécessaire pour l'API
chmod 644 "$WEB_DIR"/README.md

echo "🌐 Installation du vhost Apache..."
cp breizhcalendar.conf "$VHOST_FILE"

echo "🔧 Activation des modules Apache nécessaires..."
a2enmod ssl
a2enmod headers
a2enmod rewrite
a2enmod proxy_fcgi

echo "✅ Activation du site..."
a2ensite breizhcalendar.conf

echo "🔄 Vérification de la configuration Apache..."
if apache2ctl configtest; then
    echo "✅ Configuration Apache valide"
else
    echo "❌ Erreur dans la configuration Apache"
    exit 1
fi

echo ""
echo "================================================"
echo "⚠️  ÉTAPES MANUELLES NÉCESSAIRES"
echo "================================================"
echo ""
echo "1. Configurer le DNS pour pointer vers ce serveur :"
echo "   $DOMAIN -> IP de ce serveur"
echo ""
echo "2. Obtenir un certificat SSL Let's Encrypt :"
echo "   sudo certbot --apache -d $DOMAIN"
echo ""
echo "3. Redémarrer Apache :"
echo "   sudo systemctl restart apache2"
echo ""
echo "4. Accéder à l'application :"
echo "   https://$DOMAIN/index-api.html"
echo ""
echo "================================================"
echo "📝 NOTES"
echo "================================================"
echo "- Fichier de config : $VHOST_FILE"
echo "- Répertoire web : $WEB_DIR"
echo "- Logs erreurs : /var/log/apache2/breizhcalendar_ssl_error.log"
echo "- Logs accès : /var/log/apache2/breizhcalendar_ssl_access.log"
echo ""
echo "✨ Installation terminée !"
